# 6 商品和订单服务中使用MQ(上)
![](https://upload-images.jianshu.io/upload_images/4685968-130ec8c83917cfae.png?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240)
## 6.1 同步
![原始流程-同步流程](https://upload-images.jianshu.io/upload_images/4685968-a01dc2ce21279cc0.png?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240)
在订单生成的时候直接扣库存，这是最初等的方式扣库存，这种方式比较简单，但是也有一系列的问题：
- 会造成有很多订单把产品库存扣除而并没有支付，这就需要有一个后台脚本，将一段时间内没有支付的订单的库存释放，把订单取消掉
- 即时扣库存，并发差

1,3商品服务,操作商品服务的 db
2,4 订单服务.操作订单服务的 db
![避免访问不同服务的 db](https://upload-images.jianshu.io/upload_images/4685968-ee5cbb291abefa4f.png?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240)
## 6.2  改造成基于消息队列的异步操作
首先考虑只将第四步异步化
分析:2,4都是操作db,第四步不再等待,
1,2,3成功后即反馈给用户
之后通过消息通知服务异步下单,若第4步异步下单失败了,倾向于重试操作,试图重新生成订单,消息队列的消息也是可回溯的
![](https://upload-images.jianshu.io/upload_images/4685968-bf2668a7336a2c8c.png?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240)
订单创建完成后,处于排队状态,然后服务发布一个事件`Order Created `  到消息队列中
即订单服务向外界发送消息:我创建了一个订单
由MQ 转发给订阅该消息的服务
![](https://upload-images.jianshu.io/upload_images/4685968-f23a16931fccdfb6.png?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240)
如果商品服务收到创建订单消息之后执行扣库存操作
注意,这里可能因为某些不可抗因素导致扣库存失败
无论成功与否,商品服务都会发送一个扣库存消息到 MQ 中,消息内容即扣库存的结果
订单服务会订阅扣库存的结果,接收到该消息后
- 如果扣库存成功,将订单的状态改为`已确认`,即下单成功
- 如果扣库存失败,将订单的状态改为`已取消`,即下单失败

欲实现上述模型要求,需要以下保证
![](https://upload-images.jianshu.io/upload_images/4685968-6f1357bff67a92d6.png?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240)
服务发出的消息,一定会被MQ收到
![](https://upload-images.jianshu.io/upload_images/4685968-e999607abd1965e5.png?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240)
前端配合排队中等界面

商品/订单服务都变成异步化,适合秒杀类场景,当流量不大时,并不太适合如此改造
# 7 异步化设计(下)
![](https://upload-images.jianshu.io/upload_images/4685968-b571edbec36d5896.png?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240)
![](https://upload-images.jianshu.io/upload_images/4685968-7e66b59f62e3f349.png?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240)
对于 CAP 理论
- zk保证 AP
- eurake 保证 CP

# 最终分析实例
当订单支付成功后，会有一个出库过程，既然有这个过程，就有可能出库失败， 他的流程是怎么样子的呢？
`  库存有两部分：一个缓存redis层，一个数据库mysql层  `

1 当客服新增了5个库存，那么，缓存redis和数据库mysql层都需要增加5个库存，这个使用分布式事务的最终一致性来满足要么全加，要么全不加库存

2 当订单生成的时候，需要扣除库存，`先扣除redis库存`，如果扣除成功，则生成订单进行支付，这个过程`不扣除mysql库存`

3 当redis库存扣干净，这个产品就无法下单了，下单就会失败,就把外层的给挡住了

4 在第2步`扣除redis库存成功后`，生成订单，进行支付，支付成功，返回我的订单中心， 会发现有一个出库过程

5 `出库过程`
一个MQ异步解耦的任务队列,这个过程是`扣除mysql库存`
-  如果扣mysql库存成功，出库成功，完成下订单整个流程，进入发货状态
- 如果扣mysql库存失败，出库失败，进行一系列的操作 
    - 订单状态改成取消
    - 返还redis库存
    - 退款

## redis库存和mysql库存
支付前是`预扣`，是`扣redis库存`，是锁定库存的过程
支付后是真正扣，`扣mysql库存`，保证库存最终一致

但是，在极端情况下会存在数据不一致
- 如果redis库存 = mysql库存，不会有问题
- 如果redis库存 < mysql库存，不会有超卖问题，但会存在实际有库存，但是没有卖的情况
- 如果redis库存 > mysql库存，就会超卖，超卖的订单，在出库的过程中会失败

这样总体不会出问题，mysql数据库层，保证库存最终不会出问题。
## 但是会有以下的问题：
### 数据库库存和redis库存不一致，如何检测？
### 如果检测出来不一致，如何同步
没有想出来好的方案
比较暴力的方式，就是找一个低峰期，譬如凌晨1点，周期性强行覆盖。 但是极端情况下还是会存在同步后不准确，譬如在同步的过程中，刚好有一个订单在支付，这个订单支付成功后，出库的过程中，扣除了mysql的库存，但是没有扣除redis的库存
```
这个就是数据库同步缓存的更新机制方面的问题
属于一致性的逻辑设计的问题
`缓存数 = 数据库库存数 - 待扣数`
当然这里面也还有其它的方案，以及考虑到一致性的要求高低，可以使用简单或复杂的方案
就看系统复杂度了，越是大系统就要拆得越细
比如待扣数又可以放到一个队列里面，或者缓存里面，同时有计数，直接读计数就行
比如放到mongo，已支付待出库的数量，一般也不会很大，count一下，也不会损失多少
所以一般系统都不能完全保障数据链不出错，但一定要有补偿，就是出错了可以纠错
要保障不出错的代价显然太大
同步是有一套刷新机制，可以定时，也可以通过MQ，或者监控不一至同步等等。。。
也叫做保障缓存数据的新鲜度
一般不会太长时间，半小时，几分钟都有可能，不同场景需求不一样
```
# 买火车票的12306，晚上的时间都不能买票，这个时间估计是在同步库存，将数据库库存同步到redis库存中， 但是买火车票之类，在订单生成前，必须扣除实际库存，也就是要扣除mysql的库存，

因为买火车票和购物不一样，购物可以付款后出库，但是买票这种，支付前就必须出库，因此，要将出库过程提前， 只有出库成功，才能生成订单，同样要引入redis库存

## 先扣缓存中的库存，扣除成功后，然后才可以去扣mysql中的库存

## 如果扣除缓存中的库存失败，就会挡在外面，返回库存不足，这些请求不会穿刺到mysql中，挡住了大多数的请求压力。

## redis库存会和mysql库存不一致，极端情况下是肯定有的，需要进行库存同步
- 当缓存库存比数据库库存多，那么就会出现，查询有票，但是就无法下单，下单的时候就说库存不足，这个情况下，就会造成数据库压力过大，不过12306应该有其他手段来规避这个问题，不过，我确实遇到过，查询的时候有票，但是无法下单的情况。

- 当缓存库存比数据库缓存少，那么不会出问题，只会出现有票，但是没有出售的情况，等完成库存同步一下， 明天又准确了。
